var fmt_hex = require("./convert_hex");

exports.createReadStream = function (mcu, sourceRange, pb) {
  var checksum = fmt_hex._RANGES['checksum'],
      range = fmt_hex._RANGES[sourceRange];
  if (!range) throw Error("Uknown source range '"+sourceRange+"'!");
  
  var hex = new fmt_hex.HexWriter(),
      cancelled = false;
  mcu.exchange('GET_DATA', makeReadPayload(mcu, checksum.start, checksum.end-checksum.start), function (e, d) {
    if (e) return hex.emit('error', e);
    else if (cancelled) return hex.end();
    hex.write({startAddress:checksum.start});
    hex.write(extractData(mcu,d));
    
    var currentAddress = range.start*range.wdsz;
    hex.write({startAddress:currentAddress});    
    function fetchNextUntilDone() {
      if (pb) pb((currentAddress - range.start) / (range.end - range.start));
      var len = Math.min(range.end-currentAddress, mcu._pgmBytes);
      if (!len) hex.end();
      else mcu.exchange('GET_DATA', makeReadPayload(mcu, currentAddress / range.wdsz, len), function (e, d) {
        if (e) return hex.emit('error', e);
        else if (cancelled) return hex.end();
        hex.write(extractData(mcu,d));
        currentAddress += d[5];
        fetchNextUntilDone();
      });
    }
    fetchNextUntilDone();
  });
  hex.close = function () {
      cancelled = true;
  }
  return hex;
}

function makeReadPayload(mcu, addr, size) {
    if (size > mcu._pgmBytes) throw Error("Too much data to fetch!");
    else if (!size) size = mcu._pgmBytes;
    
    var payload = Buffer(63);
    payload.fill(0);
    payload.writeUInt32LE(addr,0);      // Address
    payload[4] = size;                  // Size
    return payload;
}

function extractData(mcu, d) {
  var len = d[5],
      off = 8 + mcu._pgmBytes - len;
  return d.slice(off, off+len);
}
